<?php

/**
 * Stretch formset.
 *
 * @package    sf_sandbox
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class StretchFormSet {
  var $name;
  var $forms;

  /*
   * Contructs and configures the formset
   * @formset_name: name (prefix) for the formset
   */
  function __construct($formset_name, $flight) {
    $this->name = $formset_name;
    $this->forms = array();
    
    // create the form objects
    foreach ($flight->Stretches as $stretch) {
      // the forms name is formed using the flight id and stretch id
      $name = $this->name.'_formset_'.$flight->id.'_'.$stretch->id;
      $this->forms[$stretch->id] = new CustomStretchForm($stretch);
      $this->forms[$stretch->id]->set_name($name);
    }
  }


  /*
   * Fills the formset with data from the request
   * @request: the WebRequest object provided by Symfony
   */  
  function bind(sfWebRequest $request) {
    // bind every form in the set
    foreach ($this->forms as $form) {
      $form->bind($request->getParameter($form->getName()),
		  $request->getFiles($form->getName()));
    }
  }
  /*
   * Validates every form in the set
   */
  function is_valid() {
    $has_errors = false;
    // validates every form in the set
    foreach ($this->forms as $form) {
	if(!$form->isValid()) {
	    $has_errors = true;
	}
      }
    return !$has_errors;
  }
  
  /*
   * Saves every form in the formset
   */
  function save() {
    foreach ($this->forms as $form) {
      $form->save();
      $form->getObject()->updateStartingTime();
      $form->getObject()->updateStoppingTime();
      $form->getObject()->updateBillableTime();
      $form->getObject()->updatePreviousStretch();
    }
  }
  
}

