<?php
class Q3Form extends BaseForm{

    protected static $vehicles;

    public function configure(){

        self::$vehicles[''] = "--- Seleccione el Vehiculo ---";
        foreach (Doctrine::getTable('Vehicle')->findAll() as $vechicle ){
            self::$vehicles[$vechicle->id] = $vechicle->model." ".$vechicle->plate." (".$vechicle->Company->name.")";
        }


        $this->setWidgets(array(
            'vehicle' => new sfWidgetFormSelect(array('choices' =>self::$vehicles )),
            'fechas'=> new sfWidgetFormDateRange(array(
                'from_date' => new sfWidgetFormDate(),
                'to_date' => new sfWidgetFormDate()
            ))
        ));

        $validVehicles = array_keys(array_slice(self::$vehicles,1,count(self::$vehicles)-1,true));
        $this->setValidators(array(
            'vehicle' => new sfValidatorChoice(
                array( 'choices' => $validVehicles ),
                array('required' => 'Debes seleccionar un viaje','invalid' => 'Viaje no válido')
            ),
            'fechas'    => new sfValidatorDateRange(array(
                'from_date'   => new sfValidatorDate(),
                'to_date' => new sfValidatorDate()
            ))
        ));

        $this->widgetSchema->setNameFormat('q3FormFields[%s]');

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'from_date',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'to_date',
                array('throw_global_error' => true),
                array('invalid' => 'The start date ("%left_field%") must be before the end date ("%right_field%")')
            )
        );

    }

}
?>