<?php
class Q1Form extends BaseForm {

    protected static $trips;

    public function configure() {
        self::$trips[''] = "--- Seleccione el Viaje ---";
        foreach (Doctrine::getTable('Trip')->findAll() as $trip ) {
            self::$trips[$trip->id] = $trip->driver." (".$trip->Vehicle->plate."@".$trip->Vehicle->Company->name.")";
        }

        $this->setWidgets(array(
                'trip' => new sfWidgetFormSelect(array('choices' =>self::$trips ))
        ));
        $this->widgetSchema->setNameFormat('q1FormFields[%s]');


        $validTrips = array_keys(array_slice(self::$trips,1,count(self::$trips)-1,true));
        $this->setValidators(array(
                'trip' => new sfValidatorChoice(
                array( 'choices' => $validTrips ),
                array('required' => 'Debes seleccionar un viaje','invalid' => 'Viaje no válido')
                )
        ));


    }

}
?>
